/****** Object:  Trigger [dbo].[TRG_PDV_VD_AUDIT_CANCELAMENTO]    Script Date: 12/07/2016 10:46:25 ******/

IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_PDV_CUPOM_NAO_FISCAL_AUDIT_CANCELAMENTO]'))
DROP TRIGGER TRG_PDV_CUPOM_NAO_FISCAL_AUDIT_CANCELAMENTO
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TRIGGER [dbo].[TRG_PDV_CUPOM_NAO_FISCAL_AUDIT_CANCELAMENTO] ON [dbo].[PDV_CUPOM_NAO_FISCAL] AFTER  UPDATE
AS
BEGIN TRY
	IF UPDATE(ST_CUPOM) 
		BEGIN
			INSERT INTO PDV_CUPOM_NAO_FISCAL_AUDIT_CANCEL 
			(CD_EMP,
			CD_FILIAL,
			CD_CTR,
			CD_USU_ALT,
			DT_ALT,
			ST_CUPOM,
			TP_CUPOM_NAO_FISCAL)
			SELECT
				C.CD_EMP,
				C.CD_FILIAL,
				C.CD_CTR,
				ISNULL(C.CD_USU,0) AS CD_USU_ALT, ---QDO CD_USU_ALT = 0 UPDATE VIA BANCO
				GETDATE() AS DT_ALT,
				C.ST_CUPOM,
				C.TP_CUPOM_NAO_FISCAL
			FROM       
			INSERTED A INNER JOIN PDV_CUPOM_NAO_FISCAL C ON
				A.CD_EMP=C.CD_EMP AND
				A.CD_FILIAL=C.CD_FILIAL AND 
				A.CD_CTR = C.CD_CTR
	
		END
END TRY
BEGIN CATCH 
    declare @erro varchar (500) = ERROR_MESSAGE();
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
			raiserror (@erro,16, 1);
END CATCH

GO


